package com.qboxus.tictic.activitesfragments.profile.usersstory

import android.content.Intent
import android.os.Build
import android.os.Bundle
import android.view.View
import android.view.Window
import android.view.WindowManager
import androidx.viewpager2.widget.ViewPager2
import com.qboxus.tictic.R
import com.qboxus.tictic.interfaces.FragmentCallBack
import com.qboxus.tictic.models.StoryModel
import com.qboxus.tictic.simpleclasses.AppCompatLocaleActivity
import com.qboxus.tictic.simpleclasses.Functions.getSharedPreference
import com.qboxus.tictic.simpleclasses.Functions.setLocale
import com.qboxus.tictic.simpleclasses.Variables

class ViewStoryA : AppCompatLocaleActivity() {
    var adapter: StoryPagerAdapter? = null
    var selectedPosition: Int = 0
    var storyDataList: ArrayList<StoryModel> = ArrayList()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setLocale(
            getSharedPreference(
                this
            ).getString(Variables.APP_LANGUAGE_CODE, Variables.DEFAULT_LANGUAGE_CODE),
            this, javaClass, false
        )
        hideNavigation()
        setContentView(R.layout.activity_view_story)
        val intent = intent
        selectedPosition = intent.getIntExtra("position", 0)
        storyDataList = intent.getParcelableArrayListExtra<StoryModel>("storyList") as ArrayList<StoryModel>

        storyDataList?.let { setupPager()}

    }

    private fun setupPager() {
        mPager = findViewById(R.id.viewPager)
        mPager.setOrientation(ViewPager2.ORIENTATION_HORIZONTAL)
        adapter = storyDataList?.let { StoryPagerAdapter(this, it, storyDeleteCallback) }
        mPager.setAdapter(adapter)
        mPager.setCurrentItem(selectedPosition)
        mPager.registerOnPageChangeCallback(object : ViewPager2.OnPageChangeCallback() {
            override fun onPageSelected(position: Int) {
                super.onPageSelected(position)
                selectedPosition = position
            }
        })
        mPager.setUserInputEnabled(false)
    }


    var storyDeleteCallback: FragmentCallBack = FragmentCallBack { bundle ->
        if (bundle.getBoolean("isShow", false)) {
            if (bundle.getString("action") == "deleteItem") {
                val itemPostion = bundle.getInt("itemPos", 0)
                val itemSelected = storyDataList!![selectedPosition]
                val videoList = itemSelected.videoList
                if (videoList!!.size > 0) {
                    videoList!!.removeAt(itemPostion)
                    itemSelected.videoList = videoList
                    storyDataList!![selectedPosition] = itemSelected
                    adapter!!.notifyDataSetChanged()
                } else {
                    storyDataList!!.removeAt(selectedPosition)
                    adapter!!.notifyDataSetChanged()
                }
            }
        }
    }


    // this will hide the bottom mobile navigation controll
    fun hideNavigation() {
        requestWindowFeature(Window.FEATURE_NO_TITLE)
        this.window.setFlags(
            WindowManager.LayoutParams.FLAG_FULLSCREEN,
            WindowManager.LayoutParams.FLAG_FULLSCREEN
        )

        val flags = (View.SYSTEM_UI_FLAG_LAYOUT_STABLE
                or View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION
                or View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                or View.SYSTEM_UI_FLAG_HIDE_NAVIGATION
                or View.SYSTEM_UI_FLAG_FULLSCREEN
                or View.SYSTEM_UI_FLAG_IMMERSIVE_STICKY)

        // This work only for android 4.4+
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            window.decorView.systemUiVisibility = flags

            // Code below is to handle presses of Volume up or Volume down.
            // Without this, after pressing volume buttons, the navigation bar will
            // show up and won't hide
            val decorView = window.decorView
            decorView
                .setOnSystemUiVisibilityChangeListener { visibility ->
                    if ((visibility and View.SYSTEM_UI_FLAG_FULLSCREEN) == 0) {
                        decorView.systemUiVisibility = flags
                    }
                }
        }
    }

    override fun onBackPressed() {
        val intent = Intent()
        intent.putExtra("isShow", true)
        setResult(RESULT_OK, intent)
        finish()
    }

    companion object {
        lateinit var mPager: ViewPager2
    }
}
